function [LogL,Rt, veclRt]=NormalCopulaLogLikhood(theta,data,corrspec,optimizer,method)
% The neggative log-likelihood of the time varying normal Copula.
% IMPUTS:
% theta:            Vector of parameters. 
% data:             matrix of U(0,1) or iid margins
% corrspec:         String with values 'DCC', 'TVC, or 'Patton'
% optimizer:        String with values 'fmincon' or 'fminunc'
% method:           String with values 'CML' or 'IFM'

% Warning:          If you want to estimate the parameters of your normal
%                   Copula, you should run the function
%                   EstimateTVNormalCopula.m, which call this function
if nargout==1
    Rt=[]; veclRt=[];
end
if nargin==4
    method='CML';
end
if nargin==3
    method='CML'; optimizer='fmincon';
end
if min(min(data))<0 || max(max(data))>1
if strcmp(method,'IFM')==1
    trdata=norminv(normcdf(data));
end
if strcmp(method,'CML')==1
    trdata=norminv(empiricalCDF(data));
end
else
    trdata=norminv(data);
end
[T,N]=size(data);
if strcmp(optimizer,'fmincon')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta,trdata);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta,trdata);
elseif strcmp(corrspec,'Patton')==1 && N==2
    display('Patton is unconstrained by default')
    [Rt, veclRt]=Pattoneq(theta,data);
elseif strcmp(corrspec,'Patton')==1 && N==2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta,trdata);
end
elseif strcmp(optimizer,'fminunc')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta,trdata,optimizer);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta,trdata,optimizer);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta,data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta,trdata,optimizer);
end  
end
% The Normal Copula likelihood function 
    LL=zeros(T,1); 
    for i=1:T
        LL(i)=-.5*log(det(Rt(:,:,i)));
        LL(i)=LL(i)-.5*trdata(i,:)*(inv(Rt(:,:,i))-eye(N))*trdata(i,:)';    
    end
    likelihood=sum(LL);
    LogL=-likelihood;
